#include <iostream>
#include <limits>

char buffer[128];

template<typename T>
void fastscan(T& x)
{    
    if constexpr (std::is_unsigned_v<T>)
    {
        T c;
        x = 0;

        do c = getchar();
        while (c < '0' || c > '9');

        do
        {
            x = (x << 1) + (x << 3) + c - 48;
            c = getchar();
        } while (c >= '0' && c <= '9');
    }
    else
    {
        T c;
        x = 0;

        do c = getchar();
        while ((c < '0' || c > '9') && c != '-');

        bool negative = (c == '-');

        if (negative)
            c = getchar();

        do
        {
            x = (x << 1) + (x << 3) + c - 48;
            c = getchar();
        } while (c >= '0' && c <= '9');

        x *= 1 - negative * 2;
    }
}

template<typename T>
void fastprint(T x)
{
    static constexpr size_t maxSize = std::numeric_limits<T>::digits10 + std::is_signed_v<T>;

    if constexpr (std::is_unsigned_v<T>)
    {
        buffer[maxSize] = '\0';        

        int i = 0;
        do
        {
            buffer[(maxSize - 1) - (i++)] = x % 10 + '0';
            x /= 10;
        } while (x != 0);        

        puts(buffer + maxSize - i);
    }
    else
    {
        buffer[maxSize] = '\0';

        bool negative = (x < 0);
        x = (negative ? -x : x);

        int i = 0;
        do
        {
            buffer[(maxSize - 1) - (i++)] = x % 10 + '0';
            x /= 10;
        } while (x != 0);

        if (negative)
        {
            ++i;
            buffer[maxSize - i] = '-';
        }

        puts(buffer + maxSize - i);
    }
}

int main()
{
    unsigned N;    
    fastscan(N);

    bool s1 = false, s2 = true;
    unsigned t1 = 0, t2 = 0;
    int l[2];
    int n[2];

    fastscan(n[0]);
    fastscan(n[1]);

    for (int i = 0; i < N - 1; ++i)
    {
        l[0] = n[0];
        l[1] = n[1];

        fastscan(n[0]);
        fastscan(n[1]);

        int d1 = abs(l[s1] - n[s1]), d2 = abs(l[s1] - n[!s1]);
        if (d1 < d2)        
            t1 += d1;        
        else
        {         
            t1 += d2;
            s1 = !s1;
        }

        d1 = abs(l[s2] - n[s2]);
        d2 = abs(l[s2] - n[!s2]);
        if (d1 < d2)
            t2 += d1;
        else
        {
            t2 += d2;
            s2 = !s2;
        }        

        if (s1 == s2)
        {
            unsigned t = (t1 > t2 ? t1 : t2);            

            for (; i < N - 1; ++i)
            {
                l[0] = n[0];
                l[1] = n[1];

                fastscan(n[0]);
                fastscan(n[1]);

                d1 = abs(l[s1] - n[s1]);
                d2 = abs(l[s1] - n[!s1]);
                if (d1 < d2)
                    t += d1;
                else
                {
                    t += d2;
                    s1 = !s1;
                }
            }

            fastprint(t);
            return 0;
        }        
    }    

    fastprint(t1 > t2 ? t1 : t2);

    return 0;
}